

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
countries = ["Country A", "Country B", "Country C", "Country D", "Country E"]
average_life_expectancy = [78.5, 82.1, 80.3, 75.4, 79.6]  # Average life expectancy (in years)
std_devs = [1.2, 1.0, 1.3, 1.4, 1.1]  # Standard deviation (in years)
global_mean_life_expectancy = [78.0]  # Global average life expectancy (in years)

xlabel = "Average Life Expectancy (in years)"
label = "Global Average Life Expectancy"
plot_title = 'Average Life Expectancy by Country'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.errorbar(
    average_life_expectancy,
    countries,
    xerr=std_devs,
    fmt="o",
    color="#0073e6",  # Blue for markers
    ecolor="#6699cc",  # Light blue for error bars
    capsize=4,
    elinewidth=2,
    markeredgewidth=2,
    label="Country Life Expectancy",
)
plt.axvline(global_mean_life_expectancy[0], color="#ff6600", linestyle="--", linewidth=3, label=label)

# Customizing the plot
plt.xlabel(xlabel)
plt.title(plot_title)
plt.legend(loc='upper right')
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_55.pdf", bbox_inches="tight")

