
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
np.random.seed(2)
tv_shows = [
    "Breaking Bad",
    "Stranger Things",
    "Game of Thrones",
    "The Crown",
    "The Mandalorian",
    "Friends",
    "The Office",
    "Westworld",
    "The Witcher",
    "Black Mirror",
]
approval_ratings = [
    88.2,
    92.5,
    85.8,
    79.4,
    95.3,
    86.7,
    91.2,
    76.8,
    89.4,
    82.1,
]
errors = [
    [3.2, -2.8],  # Error margins in Approval Rating (%)
    [2.5, -1.9],
    [3.7, -2.2],
    [3.1, -2.7],
    [2.2, -1.8],
    [3.3, -2.1],
    [2.6, -2.0],
    [2.9, -1.7],
    [3.0, -2.5],
    [2.8, -1.9],
]
methods = [
    "Viewer Surveys",
    "Online Reviews",
    "Critic Ratings",
    "Focus Groups",
    "Social Media Analysis",
    "Streaming Data",
    "Award Wins",
    "Fan Polls",
    "Binge Watching Stats",
    "Audience Scores",
]
xticks = np.arange(70.0, 100.0, 5.0)  # Adjusted for the range of approval ratings
xlim = [70.0, 100.0]
xvline = 85.0  # Average approval rating in %
xvspan = [80.0, 90.0]  # Range near average approval rating
xlabel = "Approval Rating (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 8))

# Error bars with different positive and negative values
for i, (show, rating, error) in enumerate(zip(tv_shows, approval_ratings, errors)):
    ax.errorbar(
        rating,
        i,
        xerr=[[abs(error[1])], [error[0]]],
        fmt="o",
        color="black",
        ecolor="blue",
        capsize=5,
        markersize=8,
    )
    ax.text(
        rating,
        i - 0.15,
        r"$%.1f^{+%.2f} _{-%.2f}$" % (rating, error[0], abs(error[1])),
        va="center",
        ha="center",
        fontsize=9,
    )

# Highlighted region with customized color and alpha
ax.axvspan(xvspan[0], xvspan[1], color="lightgreen", alpha=0.3)

# Text for methods with adequate font size
for i, method in enumerate(methods):
    ax.text(102, i, method, va="center", ha="left", fontsize=11)

# Set labels and title
ax.set_yticks(range(len(tv_shows)))
ax.set_yticklabels(tv_shows)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_xlim(xlim)
ax.invert_yaxis()  # Invert y-axis to match the original image
ax.axvline(x=xvline, linestyle="--", color="red", linewidth=1.5)

# Adjust x-axis ticks and labels
ax.set_xticks(xticks)
ax.set_xticklabels([f"{x:.1f}" for x in xticks])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save/show the plot
plt.tight_layout()
plt.savefig("errorpoint_59.pdf", bbox_inches="tight")

