

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data (example values, replace with actual data)
categories = [
    "Metaphysics",
    "Epistemology",
    "Ethics",
    "Logic",
    "Aesthetics",
    "Political Philosophy",
]
unique_initiative_mean = [
    75,
    80,
    65,
    70,
    68,
    60,
]  # Example mean values for unique initiatives in philosophy
unique_challenge_mean = [
    30,
    25,
    35,
    28,
    32,
    33,
]  # Example mean values for unique challenges in philosophy
unique_initiative_error = [
    7,
    8,
    6,
    7.5,
    6.8,
    6,
]  # Example error values for unique initiatives
unique_challenge_error = [
    4,
    3.5,
    4.5,
    4,
    4.2,
    3.8,
]  # Example error values for unique challenges
labels = ["Unique initiative count mean in Philosophy", "Unique challenge count mean in Philosophy"]
ylabel = "Number of Unique Initiatives"
axlabel = "Average Unique Challenge Count"
title = "Average Number of Unique Initiatives and Challenges in Different Fields of Philosophy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(12, 8)
)  # Adjust the size to match the original image's dimensions
ax.errorbar(
    categories,
    unique_initiative_mean,
    yerr=unique_initiative_error,
    fmt="o",
    color="#1f77b4",
    label=labels[0],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)
ax.errorbar(
    categories,
    unique_challenge_mean,
    yerr=unique_challenge_error,
    fmt="s",
    color="#ff7f0e",
    label=labels[1],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=np.mean(unique_challenge_mean),
    color="grey",
    linestyle="--",
    linewidth=2,
    label=axlabel,
)
ax.legend()
ax.set_title(title)
ax.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_60.pdf", bbox_inches="tight")

