

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Fiction",
    "Non-Fiction",
    "Mystery",
    "Biography",
    "Sci-Fi",
    "Fantasy",
]
avg_sales_mean = [350, 200, 400, 150, 320, 280]  # Average book sales
avg_reviews_mean = [150, 100, 250, 50, 180, 200]  # Average book reviews
avg_sales_error = [30, 20, 35, 10, 25, 28]  # Error margins for average sales
avg_reviews_error = [15, 10, 20, 5, 18, 20]  # Error margins for average reviews

labels = ["Average Sales", "Average Reviews"]
ylabel = "Average Count"
xlabel = "Book Genre"
title = "Average Book Sales and Reviews Across Different Genres"
refline_label = "Average Reviews Reference Line"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 8))

color_sales = "mediumseagreen"
color_reviews = "royalblue"
color_refline = "grey"

# Sales data
ax.errorbar(
    categories,
    avg_sales_mean,
    yerr=avg_sales_error,
    fmt="o",
    color=color_sales,
    label=labels[0],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Reviews data
ax.errorbar(
    categories,
    avg_reviews_mean,
    yerr=avg_reviews_error,
    fmt="s",
    color=color_reviews,
    label=labels[1],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticklabels(categories, rotation=45, ha="right")

# Reference line for average reviews
avg_reviews_ref = np.mean(avg_reviews_mean)
ax.axhline(
    y=avg_reviews_ref,
    color=color_refline,
    linestyle="--",
    linewidth=2,
    label=refline_label,
)

# Legend and title
ax.legend()
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_61.pdf", bbox_inches="tight")

