

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Energy domain
categories = [
    "Solar",
    "Wind",
    "Hydro",
    "Nuclear",
    "Geothermal",
    "Biomass",
]
unique_production_mean = [350, 420, 300, 500, 260, 320]  # Mean values for production
unique_consumer_mean = [
    2800,
    3100,
    2700,
    3500,
    2400,
    2900,
]  # Mean values for consumption
production_error = [35, 42, 30, 50, 26, 32]  # Error values for production
consumer_error = [280, 310, 270, 350, 240, 290]  # Error values for consumption
labels = ["Average Production (MW)", "Average Consumption (MW)"]
ylabel = "Energy Production (MW)"
axlabel = "Average Energy Consumption"
title = "Analysis of Energy Production and Consumption by Source"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars and markers
ax.errorbar(
    categories,
    unique_production_mean,
    yerr=production_error,
    fmt="o",
    color="#1f77b4",  # Deep blue
    marker="s",
    markersize=8,
    label=labels[0],
)
ax.errorbar(
    categories,
    unique_consumer_mean,
    yerr=consumer_error,
    fmt="o",
    color="#ff7f0e",  # Bright orange
    marker="D",
    markersize=8,
    label=labels[1],
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=sum(unique_consumer_mean) / len(unique_consumer_mean),
    color="grey",
    linestyle="--",
    linewidth=1.5,
    label=axlabel,
)

# Title and Grid
ax.set_title(title)
ax.grid(True, linestyle="--", linewidth=0.5)

# Legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_63.pdf", bbox_inches="tight")
