
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Science domain
categories = [
    "Biological",
    "Chemical",
    "Physical",
    "Computational",
    "Earth",
    "Social",
]
unique_speaker_mean = [85, 90, 75, 95, 80, 70]  # Mean values for researchers
unique_shouter_mean = [500, 600, 450, 700, 550, 400]  # Mean values for conference attendees
unique_speaker_error = [8, 7, 10, 9, 6, 7]  # Error values for researchers
unique_shouter_error = [50, 60, 40, 70, 55, 45]  # Error values for conference attendees
labels = ["Researchers count mean", "Attendees count mean"]
ylabel = "Number of Researchers"
axlabel = "Average Attendees Count"
title = "Analysis of Researchers and Attendees in Scientific Fields"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars and markers
ax.errorbar(
    categories,
    unique_speaker_mean,
    yerr=unique_speaker_error,
    fmt="o",
    color="#1f77b4",  # A shade of blue
    marker="s",
    markersize=8,
    label=labels[0],
)
ax.errorbar(
    categories,
    unique_shouter_mean,
    yerr=unique_shouter_error,
    fmt="o",
    color="#2ca02c",  # A shade of green
    marker="D",
    markersize=8,
    label=labels[1],
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=sum(unique_shouter_mean) / len(unique_shouter_mean),
    color="gray",
    linestyle="--",
    linewidth=1.5,
    label=axlabel,
)

# Title and Grid
ax.set_title(title)
ax.grid(True, linestyle="--", linewidth=0.5)

# Legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_64.pdf", bbox_inches="tight")
