
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Importing numpy for handling data

# Data for Philosophical Analysis
categories = [
    "Stoicism",
    "Existentialism",
    "Nihilism",
    "Rationalism",
    "Empiricism",
    "Idealism",
]

mean_philosophers = [20, 35, 15, 40, 25, 30]  # Example mean values for philosophers
mean_followers = [50, 70, 20, 90, 65, 55]  # Example mean values for followers
philosophers_error = [5, 7, 3, 10, 4, 6]  # Example error values for philosophers
followers_error = [10, 15, 5, 20, 13, 10]  # Example error values for followers
labels = ["Mean Philosophers", "Mean Followers"]
ylabel = "Number of People"
axlabel = "Average Follower Count"
title = "Philosophical Schools Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars and markers
ax.errorbar(
    categories,
    mean_philosophers,
    yerr=philosophers_error,
    fmt="o",
    color="skyblue",
    marker="s",  # Square marker
    markersize=8,
    label=labels[0],
)
ax.errorbar(
    categories,
    mean_followers,
    yerr=followers_error,
    fmt="o",
    color="lightgreen",
    marker="o",  # Circle marker
    markersize=8,
    label=labels[1],
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=sum(mean_followers) / len(mean_followers),
    color="grey",
    linestyle="--",
    linewidth=1.5,
    label=axlabel,
)

# Title and Grid
ax.set_title(title)
ax.grid(True, linestyle="--", linewidth=0.5)

# Legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_65.pdf", bbox_inches="tight")
