
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
regions = [
    "North America",
    "Europe",
    "Asia",
    "Africa",
    "South America",
]
avg_temperatures = [12.5, 10.3, 15.2, 25.3, 20.1]  # Example average temperatures (°C)
errors = [1.3, 0.8, 1.1, 1.5, 0.9]  # Example upper error margins (°C)
downerrors = [1.1, 0.7, 1.0, 1.2, 0.8]  # Example lower error margins (°C)
legendtitles = ["Dataset Mean", "Mean Temperature"]
texttitle = "Average Annual Temperatures in Regions"
xlabel = "Regions"
ylabel = "Temperature (°C)"
title = "Average Annual Temperatures by Region"
dataset_mean = 16.68

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 8))

# Adjusting color scheme and marker style
ax.errorbar(
    regions,
    avg_temperatures,
    yerr=[errors, downerrors],
    fmt="s",
    color="forestgreen",
    ecolor="forestgreen",
    capsize=5,
    markersize=8,
    markerfacecolor="darkblue",
    markeredgewidth=2,
)

# Adding a legend with both "Mean Temperature" and "Dataset Mean"
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="^", color="forestgreen", ecolor="forestgreen", capsize=5, markersize=8,
    markerfacecolor="darkblue", markeredgewidth=2
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color="darkred", linestyle="--", linewidth=2
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
    fontsize=10,
    weight='bold'
)

# Setting labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_66.pdf", bbox_inches="tight")
