
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "GDP GROWTH RATE",
    "INFLATION RATE",
    "UNEMPLOYMENT RATE",
    "INTEREST RATE",
    "TRADE BALANCE",
]  # Capitalized category labels
means = [0.03, 0.012, 0.045, 0.015, -0.02]  # Quarterly percentage change
errors = [0.005, 0.003, 0.006, 0.004, 0.007]  # Standard error margins
downerrors = [0.004, 0.002, 0.005, 0.003, 0.006]
legendtitles = ["Quarterly Change", "Historical Mean"]
texttitle = "Expected Range"
title = "Quarterly Economic Indicators"
ylabel = "Change (Percentage)"
xlabel = "Economic Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjusting figure size to match new image dimensions
ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color="gold",
    ecolor="darkorange",
    capsize=5,
    markerfacecolor="lightgoldenrodyellow",
    markeredgewidth=2,
    markeredgecolor="gold",
)

# Adding a legend with both "Mean" and "Historical Mean"
historical_mean = 0.02
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color="gold", ecolor="darkorange", capsize=5
)
historical_mean_line = ax.axhline(
    y=historical_mean, color="navy", linestyle="--", linewidth=1
)
ax.legend(
    [historical_mean_line, mean_line],
    legendtitles,
    loc="upper left",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)
# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    historical_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels and a title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
plt.xticks(rotation=30)
plt.grid(True, which="both", axis="y", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_69.pdf", bbox_inches="tight")
