

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Importing additional necessary library
import numpy as np

# Data for plotting
categories = [
    "Creativity",
    "Aesthetics",
    "Technique",
    "Innovation",
    "Popularity",
]  # Art and Design attributes
means = [0.85, 0.70, 0.65, 0.80, 0.75]  # Mean values reflecting study trends in art and design
errors = [0.07, 0.05, 0.06, 0.04, 0.05]  # Error margins
downerrors = [0.05, 0.04, 0.05, 0.03, 0.04]
legendtitles = ["Mean", "Dataset mean"]
texttitle = "Average"
title = "Art and Design Attributes: Study Trends"
ylabel = "Mean Scores"
xlabel = "Art and Design Attributes"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjusting figure size
ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color="darkblue",
    ecolor="purple",
    capsize=5,
    markerfacecolor="lightblue",
    markeredgewidth=2,
    markeredgecolor="navy",
)

# Adding a legend with both "Mean" and "Dataset mean"
dataset_mean = 0.75  # Adjusted dataset mean to reflect art and design domain data
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color="darkblue", ecolor="purple", capsize=5
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color="gray", linestyle="--", linewidth=1
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)
# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels and a title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
plt.xticks(rotation=30)
plt.grid(True, which="both", axis="y", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_71.pdf", bbox_inches="tight")
