# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
months = [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
]

x = np.arange(len(months))  # Months
cityA_temps = np.random.uniform(-5, 15, len(months))
cityB_temps = np.random.uniform(0, 25, len(months))
cityC_temps = np.random.uniform(5, 35, len(months))

error_cityA = [
    np.random.uniform(1, 3, len(months)),
    np.random.uniform(1, 3, len(months)),
]
error_cityB = [
    np.random.uniform(1, 4, len(months)),
    np.random.uniform(1, 4, len(months)),
]
error_cityC = np.random.uniform(2, 6, len(months))

chart_title = "Monthly Average Temperatures of Cities in 2023 with Error Bars"
highlight_month = 6  # July

ylabel = [
    "City A Temperature (°C)",
    "City B Temperature (°C)",
    "City C Temperature (°C)",
]
xlabel = "Month"
legend_labels = ["City A", "City B", "City C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 12), nrows=3, sharex=True)

colors_cityA = plt.get_cmap("viridis")(np.linspace(0.2, 0.8, len(months)))
colors_cityB = plt.get_cmap("plasma")(np.linspace(0.2, 0.8, len(months)))
color_cityC = "orange"

# First subplot with symmetric vertical error bars (City A temperatures)
for i in range(len(x)):
    ax0.errorbar(
        x[i],
        cityA_temps[i],
        yerr=[[error_cityA[0][i]], [error_cityA[1][i]]],
        fmt="o",
        color=colors_cityA[i],
        capsize=4,
    )
    ax0.text(
        x[i] - 0.2,
        cityA_temps[i] + 0.5,
        f"{cityA_temps[i]:.2f}",
        fontsize=8,
        ha="right",
    )
ax0.set_title(chart_title)
ax0.axhline(y=5, linestyle="--", color="#6b8e23")
ax0.set_ylabel(ylabel[0])
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric horizontal error bars (City B temperatures)
for i in range(len(x)):
    ax1.errorbar(
        x[i],
        cityB_temps[i],
        xerr=[[error_cityB[0][i]], [error_cityB[1][i]]],
        fmt="o",
        color=colors_cityB[i],
        markersize=8,
    )
    ax1.text(
        x[i] + 0.1,
        cityB_temps[i] + 0.5,
        f"{cityB_temps[i]:.2f}",
        fontsize=8,
        ha="left",
    )
ax1.axvline(x=highlight_month, linestyle="--", color="#d45500")
ax1.set_ylabel(ylabel[1])
ax1.yaxis.grid(True)
ax1.xaxis.grid(False)

# Third subplot with symmetric vertical error bars (City C temperatures)
ax2.errorbar(x, cityC_temps, yerr=error_cityC, fmt="*", color=color_cityC, capsize=2)
for i in range(len(x)):
    ax2.text(
        x[i],
        cityC_temps[i] + 0.5,
        f"{cityC_temps[i]:.2f}",
        fontsize=8,
        ha="center",
    )
ax2.set_ylabel(ylabel[2])
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set shared x-axis labels
plt.xticks(x, months)
ax2.set_xlabel(xlabel)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_78.pdf", bbox_inches="tight")
