# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a directed graph
G = nx.DiGraph()
# Text Labels and Other Parameters
philosopher_labels = {
    0: "Aristotle",
    1: "Plato",
    2: "Socrates",
    3: "Descartes",
    4: "Kant",
    5: "Hume",
    6: "Nietzsche",
}
influence_labels = ["Era 1", "Era 2", "Era 3", "Era 4"]
# Define influence using edges
influence_edges = [
    (2, 1, "Taught"),
    (1, 0, "Mentored"),  # Socrates to Plato, Plato to Aristotle
    (0, 3, "Influenced"),
    (0, 4, "Teacher"),  # Aristotle to Descartes and Kant
    (3, 5, "Inspired"),
    (4, 6, "Mentor"),  # Descartes to Hume, Kant to Nietzsche
    (5, 6, "Teacher"),  # Hume to Nietzsche
]
title = "Historical Influence of Philosophers"
suptitle = "Philosophical Mentorship and Influence"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define philosophers with distinct colors
philosophers = {
    0: "#1F77B4",  # blue
    1: "#FF7F0E",  # orange
    2: "#2CA02C",  # green
    3: "#D62728",  # red
    4: "#9467BD",  # purple
    5: "#8C564B",  # brown
    6: "#E377C2",  # pink
}

for node, color in philosophers.items():
    G.add_node(node, color=color, label=philosopher_labels[node])

for u, v, label in influence_edges:
    G.add_edge(u, v, label=label)

# Define node positions in a shell layout for better visualization
pos = nx.shell_layout(G)

fig, ax = plt.subplots(figsize=(10, 10))

# Draw nodes with custom colors
node_colors = [G.nodes[node]["color"] for node in G.nodes]
nx.draw_networkx_nodes(G, pos, node_color=node_colors, node_size=600, ax=ax)

# Draw edges with arrows and custom styles
nx.draw_networkx_edges(G, pos, arrows=True, arrowstyle="->", ax=ax)

# Draw edge labels (influence outcomes)
edge_labels = {(u, v): G[u][v]["label"] for u, v in G.edges}
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_color="blue", ax=ax)

# Draw node labels (philosopher names)
node_labels = {node: G.nodes[node]["label"] for node in G.nodes}
nx.draw_networkx_labels(
    G, pos, labels=node_labels, font_size=12, font_color="black", ax=ax
)

# Remove axis
plt.axis("off")

# Title and Annotations
plt.title(title, fontsize=15)
plt.suptitle(suptitle, fontsize=20)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_22.pdf", bbox_inches="tight")
