

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Create a directed graph
G = nx.DiGraph()

# Define node labels and their respective colors
nodes = {
    'Action': "lightblue",
    'Adventure': "lightgreen",
    'Sci-Fi': "mediumpurple",
    'Fantasy': "mediumorchid",
    'Drama': "lightcoral",
    'Thriller': "lightskyblue",
    'Horror': "lightgoldenrodyellow",
}
for node, color in nodes.items():
    G.add_node(node, color=color)

# Define edges with labels
edges = [
    ('Action', 'Adventure', "Influence"),
    ('Adventure', 'Sci-Fi', "Evolution"),
    ('Sci-Fi', 'Fantasy', "Influence"),
    ('Drama', 'Thriller', "Evolution"),
    ('Thriller', 'Horror', "Influence"),
    ('Horror', 'Fantasy', "Evolution")
]
for u, v, label in edges:
    G.add_edge(u, v, label=label)

# Define node positions in a spring layout for better visualization
pos = nx.spring_layout(G)

# Text labels for axes and title
title = "Influences and Evolution in Film Genres"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 8))

# Extract node colors
node_colors = [G.nodes[node]["color"] for node in G.nodes]
nx.draw_networkx_nodes(G, pos, node_color=node_colors, node_size=3000, edgecolors='black')

# Draw edges with styles based on label
solid_edges = [(u, v) for u, v, d in G.edges(data=True) if d['label'] == "Influence"]
dashed_edges = [(u, v) for u, v, d in G.edges(data=True) if d['label'] == "Evolution"]

nx.draw_networkx_edges(G, pos, edgelist=solid_edges, arrows=True, arrowstyle="-|>", edge_color="navy")
nx.draw_networkx_edges(G, pos, edgelist=dashed_edges, arrows=True, style='dashed', edge_color="firebrick")

# Draw edge labels
edge_labels = {(u, v): G[u][v]["label"] for u, v in G.edges}
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_size=10)

# Draw node labels
nx.draw_networkx_labels(G, pos, font_size=12, font_color='black')

# Add title
plt.title(title, size=16)

# Remove axis
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_23.pdf", bbox_inches="tight")

