
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
G = nx.Graph()

# Adding nodes with specific positions
pos = {
    'Agriculture': (0, 0), 
    'Manufacturing': (1, 0), 
    'Services': (0, 1), 
    'Finance': (1, 1), 
    'Information Technology': (0.5, 2.0)
}

# Adding edges between sectors
G.add_edges_from([
    ('Agriculture', 'Manufacturing'),
    ('Agriculture', 'Services'),
    ('Manufacturing', 'Finance'),
    ('Services', 'Finance'),
    ('Finance', 'Information Technology'),
    ('Services', 'Information Technology')
])

# Labels for economic context
labels = {
    'Agriculture': "Agriculture",
    'Manufacturing': "Manufacturing",
    'Services': "Services",
    'Finance': "Finance",
    'Information Technology': "IT"
}

# Title and legend labels
title = "Economic Sectors Network"
legend_labels = {
    'Information Technology': "IT",
    'Agriculture': "Agriculture",
    'Manufacturing': "Manufacturing",
    'Services': "Services / Finance"
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Colors for different nodes
node_colors = {
    'Information Technology': "#00aaff",
    'Agriculture': "#ffaa00",
    'Manufacturing': "#ff44aa",
    'Services': "#77dd77"
}

# Draw nodes
nx.draw_networkx_nodes(G, pos, node_size=2500, nodelist=['Information Technology'], node_color=node_colors['Information Technology'])
nx.draw_networkx_nodes(G, pos, node_size=1800, nodelist=['Agriculture'], node_color=node_colors['Agriculture'])
nx.draw_networkx_nodes(G, pos, node_size=1500, nodelist=['Manufacturing'], node_color=node_colors['Manufacturing'])
nx.draw_networkx_nodes(G, pos, node_size=1300, nodelist=['Services', 'Finance'], node_color=node_colors['Services'])

# Draw edges
nx.draw_networkx_edges(G, pos, alpha=0.7, width=4, edge_color="#a0a0a0")

# Adding labels
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_color="#333333")

# Adding a title
plt.title(title, fontsize=20)
plt.axis("off")

# Create custom legend
from matplotlib.lines import Line2D
legend_elements = [Line2D([0], [0], marker='o', color='w', label=label, 
                          markerfacecolor=color, markersize=15) 
                   for label, color in zip(legend_labels.values(), ["#00aaff", "#ffaa00", "#ff44aa", "#77dd77"])]

plt.legend(handles=legend_elements, loc='upper right', fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_31.pdf", bbox_inches="tight")
