

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Define text label parameters
title = "Agricultural Activity Relationship Throughout a Season"
legend_labels = ["Self-loop: Repeated Irrigation", "Regular Tasks"]
node_labels = {0: 'Soil Preparation', 1: 'Planting', 2: 'Irrigation', 3: 'Harvesting'}

# Create a directed graph (DiGraph) and add nodes with self-loops
G = nx.complete_graph(4, create_using=nx.DiGraph)
G.add_edges_from([(2, 2)])  # Add self-loop only for Irrigation
pos = nx.spring_layout(G)

# Edgelist for self-loops
edgelist = [(2, 2)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Draw the complete graph with custom colors and node size
nx.draw(G, pos, with_labels=True, labels=node_labels, node_size=7000, node_color="#FFD700", font_size=12, font_weight='bold')

# Draw self-loops with custom arrow style and line style
nx.draw_networkx_edges(G, pos, edgelist=edgelist, arrowstyle="<|-", style="dashed", edge_color="#FF6347", width=2)

# Create a legend for the self-loops and regular tasks
from matplotlib.lines import Line2D

legend_elements = [
    Line2D([0], [0], color='#FF6347', lw=2, linestyle='dashed', label=legend_labels[0]),
    Line2D([0], [0], color='#000000', lw=2, label=legend_labels[1])
]

plt.legend(handles=legend_elements, loc='upper left')

# Title and layout adjustments
plt.title(title, fontsize=16, fontweight='bold')
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("graph_33.pdf", bbox_inches="tight")

