
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a simple directed graph to represent philosophical influences
G = nx.DiGraph()

# Add nodes representing different philosophers
philosophers = ["Aristotle", "Plato", "Socrates", "Nietzsche", "Kant", "Descartes", "Confucius", "Laozi"]
G.add_nodes_from(philosophers)

# Add edges representing influences with weights indicating influence strength
influences = [
    ("Aristotle", "Plato", 4),
    ("Plato", "Socrates", 5),
    ("Nietzsche", "Kant", 3),
    ("Socrates", "Aristotle", 2),
    ("Kant", "Descartes", 3),
    ("Confucius", "Laozi", 2),
    ("Laozi", "Confucius", 3),
    ("Descartes", "Aristotle", 2),
    ("Plato", "Nietzsche", 2),
    ("Socrates", "Confucius", 1),
]
G.add_weighted_edges_from(influences)

pos = nx.spring_layout(G, seed=42)  # Fixed layout for reproducibility

# Draw edge labels
edge_labels = nx.get_edge_attributes(G, "weight")

title = "Influence Network Among Philosophers"
legend = ["Influence Strength"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw nodes with different sizes based on their importance
node_sizes = [G.degree(node) * 300 for node in G.nodes()]
nx.draw_networkx_nodes(
    G, pos, node_size=node_sizes, node_color="skyblue", edgecolors="darkblue"
)

# Draw edges with varying thickness based on weight
edge_weights = [G[u][v]["weight"] for u, v in G.edges()]
nx.draw_networkx_edges(
    G, pos, width=edge_weights, edge_color="gray", arrowstyle="-|>", arrowsize=15
)

# Add labels
nx.draw_networkx_labels(G, pos, font_size=12, font_weight="bold")
nx.draw_networkx_edge_labels(
    G, pos, edge_labels=edge_labels, font_color="darkred", font_size=10
)

# Add title and legend
plt.title(title, fontsize=16)
plt.legend(legend, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_36.pdf", bbox_inches="tight")
