

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
import networkx as nx

np.random.seed(0)
# Create a random graph representing a literature network
G = nx.random_geometric_graph(30, 0.3)

# Position the nodes using the Kamada-Kawai layout algorithm for a spread-out structure
pos = nx.kamada_kawai_layout(G)

# Randomly select some edges to color as 'frequent collaborations'
edges = list(G.edges())
frequent_collaborations = np.random.choice(
    len(edges), size=int(len(edges) * 0.3), replace=False
)  # Highlighting 30% of the edges
frequent_collaborations = [edges[i] for i in frequent_collaborations]

# Labels and title
title = "Literature Network: Author Collaborations"
labels = ["Frequent Collaborations", "Occasional Collaborations"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.subplots(figsize=(12, 12))

# Draw the nodes with a distinct color
nx.draw_networkx_nodes(
    G, pos, node_size=400, node_color="#54a0ff", edgecolors="#2c3e50", linewidths=0.8
)

# Draw the edges with a light transparency
nx.draw_networkx_edges(G, pos, edge_color="#ced6e0", alpha=0.6)

# Draw the selected 'frequent collaboration' edges with a strong color
nx.draw_networkx_edges(
    G, pos, edgelist=frequent_collaborations, edge_color="#1e90ff", width=2.5
)

# Add a title
plt.title(title, fontsize=20, fontweight='bold')

# Add a legend
strong_patch = plt.Line2D(
    [], [], color="#1e90ff", linewidth=2.5, linestyle="-", label=labels[0]
)
all_patch = plt.Line2D(
    [], [], color="#ced6e0", linewidth=2, linestyle="-", alpha=0.6, label=labels[1]
)
plt.legend(handles=[strong_patch, all_patch], fontsize=14, loc='upper right')

# Remove axis
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_49.pdf", bbox_inches="tight")

