

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a new graph representing a technology ecosystem network
G = nx.Graph()

# Add nodes representing different tech-related entities
nodes = [
    ("Company A", {"type": "Company"}),
    ("Company B", {"type": "Company"}),
    ("Developer X", {"type": "Developer"}),
    ("Developer Y", {"type": "Developer"}),
    ("Language Python", {"type": "Language"}),
    ("Framework Django", {"type": "Framework"}),
]
G.add_nodes_from(nodes)

# Add edges representing collaborations or interactions
edges = [
    ("Company A", "Company B"),
    ("Company A", "Developer X"),
    ("Company B", "Developer Y"),
    ("Developer X", "Language Python"),
    ("Developer Y", "Framework Django"),
    ("Language Python", "Framework Django"),
    ("Framework Django", "Company A"),
]
G.add_edges_from(edges)

# Define positions for nodes explicitly
pos = {
    "Company A": (1, 2),
    "Company B": (1, 0.5),
    "Developer X": (0.5, 1.5),
    "Developer Y": (1.5, 1.5),
    "Language Python": (0.5, 1),
    "Framework Django": (1.5, 1),
}
title = "Technology Ecosystem Network"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Node color mapping based on entity type
color_map = {
    "Company": "#FF6B6B",
    "Developer": "#6BFFB3",
    "Language": "#6B83FF",
    "Framework": "#FFD36B",
}

# Draw nodes with colors based on their type
node_colors = [color_map[G.nodes[node]["type"]] for node in G.nodes]
nx.draw_networkx_nodes(
    G, pos, node_color=node_colors, node_size=4000, edgecolors="black"
)

# Draw edges with customized style
nx.draw_networkx_edges(
    G, pos, edge_color="gray", alpha=0.8, width=2.5, style="dashed"
)

# Add labels to nodes
labels = {node: node for node in G.nodes}
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_color="black", font_family="sans-serif", font_weight="bold")

# Create legend for node colors
import matplotlib.patches as mpatches

legend_elements = [
    mpatches.Patch(color=color, label=label) for label, color in color_map.items()
]
plt.legend(handles=legend_elements, loc="upper left", frameon=False, fontsize=12)

# Title and axis settings
plt.title(title, fontsize=20, fontweight="bold", fontname="sans-serif")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_51.pdf", bbox_inches="tight")

