
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a new graph representing a communication network
G = nx.Graph()

# Add nodes representing different components in a communication system
nodes = [
    ("Satellite", {"type": "Infrastructure"}),
    ("Ground Station", {"type": "Infrastructure"}),
    ("ISP", {"type": "Service Provider"}),
    ("Mobile User", {"type": "User"}),
    ("Enterprise User", {"type": "User"}),
    ("Government", {"type": "Government"}),
]
G.add_nodes_from(nodes)

# Add edges representing interactions
edges = [
    ("Satellite", "Ground Station"),
    ("Ground Station", "ISP"),
    ("ISP", "Mobile User"),
    ("ISP", "Enterprise User"),
    ("ISP", "Government"),
    ("Ground Station", "Government"),
    ("Satellite", "Government"),
]
G.add_edges_from(edges)

# Define positions for nodes explicitly
pos = {
    "Satellite": (1, 3),
    "Ground Station": (1, 2),
    "ISP": (1, 1),
    "Mobile User": (0.5, 0),
    "Enterprise User": (1.5, 0),
    "Government": (2, 2),
}
title = "Communication Network Architecture"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Node color mapping based on entity type
color_map = {
    "Infrastructure": "lightcoral",
    "Service Provider": "lightskyblue",
    "User": "lightgreen",
    "Government": "lightgoldenrodyellow",
}
# Draw nodes with colors based on their type
node_colors = [color_map[G.nodes[node]["type"]] for node in G.nodes]
nx.draw_networkx_nodes(
    G, pos, node_color=node_colors, node_size=4000, edgecolors="black"
)

# Draw edges with alpha for transparency and consistent width
nx.draw_networkx_edges(G, pos, edge_color="gray", alpha=0.7, width=2.5)

# Add labels to nodes
labels = {node: node for node in G.nodes}
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_color="black")

# Create legend for node colors
import matplotlib.patches as mpatches

legend_elements = [
    mpatches.Patch(color=color, label=label) for label, color in color_map.items()
]
plt.legend(handles=legend_elements, loc="upper left", frameon=False, fontsize=12)

# Title and axis settings
plt.title(title, fontsize=20, fontweight="bold")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_52.pdf", bbox_inches="tight")
