
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph representing historical alliances and conflicts
G = nx.DiGraph()

# Add nodes representing countries
G.add_nodes_from(["England", "France", "Spain", "German States", "Austria-Hungary"])

# Add edges representing alliances and conflicts
alliance_edges = [("England", "Austria-Hungary"), ("France", "Spain"), ("German States", "Austria-Hungary"), ("England", "German States"), ("Austria-Hungary", "Spain")]

# Add self-loops representing internal conflicts within each country
conflict_edges = [("England", "England"), ("France", "France"), ("Spain", "Spain"), ("German States", "German States"), ("Austria-Hungary", "Austria-Hungary")]

# Combine all edges
G.add_edges_from(alliance_edges + conflict_edges)

# Position nodes using a circular layout
pos = nx.circular_layout(G)

# Text labels and other plot annotations
title = "European Alliances and Conflicts Network (Historical)"
xlabel = ""
ylabel = ""
annotation_text = "Solid Lines: Alliances\nDashed Lines: Internal Conflicts"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Draw the graph with custom node and edge colors
node_color = "deepskyblue"
edge_color = "lightgray"
nx.draw(G, pos, with_labels=True, node_color=node_color, edge_color=edge_color, node_size=3000, font_size=12, font_color="black")

# Highlight the alliance edges with bold solid lines
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=alliance_edges,
    edge_color="blue",
    style="solid",
    width=2,
    arrowstyle="->",
    arrowsize=20
)

# Highlight the conflict edges with bold dashed lines and different arrow style
nx.draw_networkx_edges(
    G, pos, edgelist=conflict_edges, edge_color="green", style="dashed", width=2, arrowstyle="<|-|>", arrowsize=20
)

# Add a title and legend to the plot
plt.title(title, fontsize=16)
props = dict(boxstyle="round", facecolor="lavender", alpha=0.5)
plt.text(
    0.05,
    0.95,
    annotation_text,
    transform=plt.gca().transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_55.pdf", bbox_inches="tight")

