

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph representing a social interaction network
G = nx.DiGraph()

# Add nodes for different community members
G.add_nodes_from([1, 2, 3, 4, 5])

# Add edges representing interactions between community members
interaction_edges = [(1, 2), (2, 3), (3, 4), (4, 5), (5, 1)]

# Add self-loops representing self-reflection activities of community members
self_loops = [(1, 1), (2, 2), (3, 3), (4, 4), (5, 5)]

# Combine all edges
G.add_edges_from(interaction_edges + self_loops)

# Position nodes using a circular layout
pos = nx.circular_layout(G)

# Labels and Annotations
title = "Community Social Interaction Network"
annotation_text = "Solid Lines: Member Interactions\nDashed Lines: Self-Reflection Activities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Draw the graph with custom node and edge colors
nx.draw(G, pos, with_labels=True, node_color="midnightblue", edge_color="darkgray")

# Highlight interaction edges with solid lines
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=interaction_edges,
    edge_color="forestgreen",
    style="solid",
    arrowstyle="->"
)

# Highlight the self-loops with dashed lines and different arrow style
nx.draw_networkx_edges(
    G, pos, edgelist=self_loops, edge_color="gold", style="dashed", arrowstyle="<|-"
)

# Add a title and legend to the plot
plt.title(title)
props = dict(boxstyle="round", facecolor="lightblue", alpha=0.5)
plt.text(
    0.05,
    0.95,
    annotation_text,
    transform=plt.gca().transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_56.pdf", bbox_inches="tight")

