

# ===================
# Part 1: Importing Libraries
# ===================
import networkx as nx
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Create a directed graph for weather phenomena
G = nx.DiGraph()
# Adding nodes representing weather types
G.add_nodes_from(
    [
        ("Sunny", {"type": "weather"}),
        ("Cloudy", {"type": "weather"}),
        ("Rainy", {"type": "weather"}),
        ("Snowy", {"type": "weather"}),
    ]
)

# Adding edges representing transitions
G.add_edges_from(
    [("Sunny", "Cloudy"), ("Cloudy", "Rainy"), ("Rainy", "Snowy"), ("Snowy", "Sunny")]
)

# Adding self-loops representing persistence
self_loops = [
    ("Sunny", "Sunny"),
    ("Cloudy", "Cloudy"),
    ("Rainy", "Rainy"),
    ("Snowy", "Snowy"),
]
G.add_edges_from(self_loops)

# Positioning nodes in a circular layout
pos = nx.circular_layout(G)

# Labels for legend and title
labels = ["Weather Transition", "Weather Persistence"]
title = "Transitions Between Different Weather Phenomena"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Draw nodes and edges with base settings
nx.draw(
    G,
    pos,
    with_labels=True,
    node_color="saddlebrown",
    node_size=3000,
    edge_color="olive",
    linewidths=1.5,
    font_size=12,
    font_weight="bold",
)

# Highlight self-loops with a different style
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=self_loops,
    edge_color="darkgreen",
    style="dashed",
    arrowstyle="<|-",
    arrowsize=20,
    width=2,
)

# Adding title and legend
plt.title(title, fontsize=16)
edge_legend = plt.Line2D([], [], linestyle="solid", color="olive", label=labels[0])
self_loop_legend = plt.Line2D(
    [], [], linestyle="dashed", color="darkgreen", label=labels[1]
)
plt.legend(handles=[edge_legend, self_loop_legend])

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_57.pdf", bbox_inches="tight")
