

# ===================
# Part 1: Importing Libraries
# ===================
import networkx as nx
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Create a directed graph for energy sectors
G = nx.DiGraph()

# Adding nodes representing sectors
G.add_nodes_from(
    [
        ("Solar", {"type": "sector"}),
        ("Wind", {"type": "sector"}),
        ("Hydro", {"type": "sector"}),
        ("Nuclear", {"type": "sector"}),
    ]
)

# Adding edges representing interactions
G.add_edges_from(
    [
        ("Solar", "Wind"),
        ("Wind", "Hydro"),
        ("Hydro", "Nuclear"),
        ("Nuclear", "Solar"),
    ]
)

# Adding self-loops representing internal activities
self_loops = [
    ("Solar", "Solar"),
    ("Wind", "Wind"),
    ("Hydro", "Hydro"),
    ("Nuclear", "Nuclear"),
]
G.add_edges_from(self_loops)

# Positioning nodes in a circular layout
pos = nx.circular_layout(G)

# Labels and annotations
labels = ["Inter-sector Communication", "Internal Sector Activities"]
title = "Interactions Between Energy Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Draw nodes and edges with base settings
nx.draw(
    G,
    pos,
    with_labels=True,
    node_color=["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"],  # New color scheme
    node_size=3000,
    edge_color="#7f7f7f",  # Neutral grey for inter-sector edges
    linewidths=1.5,
    font_size=12,
    font_weight="bold",
)

# Highlight self-loops with a different style
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=self_loops,
    edge_color="#9467bd",  # Purple color for self-loops
    style="dashed",
    arrowstyle="<|-",
    arrowsize=15,
    width=2,
)

# Adding title and legend
plt.title(title, fontsize=16)
edge_legend = plt.Line2D([], [], linestyle="solid", color="#7f7f7f", label=labels[0])
self_loop_legend = plt.Line2D([], [], linestyle="dashed", color="#9467bd", label=labels[1])
plt.legend(handles=[edge_legend, self_loop_legend])

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_59.pdf", bbox_inches="tight")

