
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Create a directed graph
G = nx.DiGraph()

# Add nodes representing different entities in the film production and distribution network
nodes = [
    "Production Studio",
    "Film Festival A",
    "Film Festival B",
    "Theater Chain 1",
    "Theater Chain 2",
    "Streaming Service",
]
for node in nodes:
    G.add_node(node)

# Define edges representing film flow between entities
edges = [
    ("Production Studio", "Film Festival A"),
    ("Production Studio", "Film Festival B"),
    ("Film Festival A", "Theater Chain 1"),
    ("Film Festival A", "Streaming Service"),
    ("Film Festival B", "Theater Chain 2"),
    ("Film Festival B", "Streaming Service"),
    ("Film Festival A", "Film Festival A"),  # Self-loop for additional screenings
    ("Film Festival B", "Film Festival B"),  # Self-loop for additional screenings
]

# Add edges to the graph
G.add_edges_from(edges)

# Define positions for a clear layout
pos = nx.spring_layout(G, seed=42)

# Define titles and labels
title = "Film Production and Distribution Network"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Define node colors based on different entities
node_colors = [
    "green" if "Production Studio" in node else
    "blue" if "Film Festival" in node else
    "orange" if "Theater Chain" in node else
    "purple" for node in G.nodes()
]

# Draw the graph with the customized node colors and labels
nx.draw(
    G,
    pos,
    with_labels=True,
    node_color=node_colors,
    node_size=3000,
    font_size=12,
    font_weight="bold",
    edge_color="gray",
)

# Draw edges with differentiated styles for self-loops
self_loops = [(u, v) for u, v in G.edges() if u == v]
other_edges = [(u, v) for u, v in G.edges() if u != v]

nx.draw_networkx_edges(
    G,
    pos,
    edgelist=other_edges,
    arrowstyle="-|>",
    arrowsize=20,
    width=2.5,
    edge_color="black",
)
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=self_loops,
    arrowstyle="-|>",
    style="dashed",
    arrowsize=20,
    width=2.5,
    edge_color="red",
)

# Title and labels
plt.title(title, fontsize=20)
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_61.pdf", bbox_inches="tight")
