
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
# import numpy for future enhancements
import numpy as np

# Create a directed graph for social media interactions
G = nx.DiGraph()

# Define nodes with user-related attributes
nodes = {
    0: ("Admin", "red"),
    1: ("Influencer", "blue"),
    2: ("Regular User A", "green"),
    3: ("Regular User B", "orange"),
    4: ("Regular User C", "purple"),
    5: ("Regular User D", "brown"),
    6: ("Regular User E", "pink"),
}
for node, (user, color) in nodes.items():
    G.add_node(node, user=user, color=color)

# Add edges with labels representing interactions
edges = [
    (0, 1, "Manages"),
    (1, 2, "Follows"),
    (2, 3, "Messages"),
    (3, 4, "Likes"),
    (4, 5, "Shares"),
    (5, 6, "Follows"),
    (6, 0, "Mentions"),
]
for u, v, label in edges:
    G.add_edge(u, v, label=label)

# Define node positions in a circular layout
pos = nx.circular_layout(G)

title = "Social Media Interaction Network"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 12))

# Draw nodes with color attribute
node_colors = [G.nodes[node]["color"] for node in G.nodes]
nx.draw_networkx_nodes(G, pos, node_color=node_colors, node_size=1000, ax=ax)

# Draw edges with labels and custom styles
nx.draw_networkx_edges(
    G,
    pos,
    arrows=True,
    arrowstyle="-|>",
    arrowsize=20,
    width=2,
    edge_color="darkgray",
    style="dashed",
    ax=ax,
)
edge_labels = {(u, v): G[u][v]["label"] for u, v in G.edges}
nx.draw_networkx_edge_labels(
    G, pos, edge_labels=edge_labels, font_color="darkred", font_size=10, ax=ax
)

# Draw node labels indicating user types
node_labels = {node: G.nodes[node]["user"] for node in G.nodes}
nx.draw_networkx_labels(
    G, pos, labels=node_labels, font_size=12, font_color="black", ax=ax
)

# Remove axis and add title
plt.axis("off")
plt.title(title, fontsize=18, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_65.pdf", bbox_inches="tight")
