

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph representing communication flow in health departments
G = nx.DiGraph()

# Add nodes representing different health departments
health_departments = {
    0: "Emergency",
    1: "Radiology",
    2: "Surgery",
    3: "Pharmacy",
    4: "Cardiology",
    5: "Pediatrics",
    6: "Neurology",
    7: "Oncology",
    8: "Orthopedics",
    9: "Gastroenterology",
    10: "Dermatology",
    11: "Administration",
}

G.add_nodes_from(health_departments.keys())

# Add edges with weights representing communication flow or collaboration
health_edges = [
    (0, 1, 5),
    (1, 2, 4),
    (2, 3, 4),
    (3, 4, 3),
    (4, 5, 2),
    (5, 6, 3),
    (6, 7, 2),
    (7, 8, 4),
    (8, 9, 3),
    (9, 10, 2),
    (10, 11, 5),
    (11, 0, 4),
]

G.add_weighted_edges_from(health_edges)

# Adjust node positions using spring layout for better visualization
pos = nx.spring_layout(G, seed=42)
title = "Health Departments and Their Collaboration Relationships"
xlabel = "X-axis"
ylabel = "Y-axis"

# Labels for nodes and edges
node_labels = health_departments
edge_labels = {(start, end): f"{weight}" for start, end, weight in health_edges}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Draw nodes with varying sizes and colors
node_size = [900 + 200 * (i % 3) for i in range(len(health_departments))]
node_color = [
    "#66c2a5" if i % 3 == 0 else "#fc8d62" if i % 3 == 1 else "#8da0cb"
    for i in range(len(health_departments))
]

nx.draw(
    G, pos, node_size=node_size, node_color=node_color, with_labels=False, arrows=True
)

# Draw labels for nodes and edges
nx.draw_networkx_labels(G, pos, labels=node_labels, font_size=10, font_color="#4c4c4c")
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_color="#e41a1c")

# Adjust plot parameters for better visualization
plt.title(title, fontsize=16, fontweight='bold')
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_66.pdf", bbox_inches="tight")

