
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate a seed for reproducibility
np.random.seed(0)

# Hypothetical average monthly temperatures for different cities
cities = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
    "Philadelphia",
    "San Antonio",
    "San Diego",
    "Dallas",
    "San Jose",
    "Austin",
    "Jacksonville",
    "Fort Worth",
    "Columbus",
    "Charlotte",
    "San Francisco",
    "Indianapolis",
    "Seattle",
]

# Generate a random grid of temperatures between -10 to 40
grid = -10 + np.random.rand(4, 4) * 50

# Labels for the chart
xlabel = "Cities"
ylabel = "Seasons"
title = "Average Monthly Temperatures Across Cities and Seasons"
suptitle = "Heatmap of Average Monthly Temperatures"
legend_labels = cities

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(
    nrows=3, ncols=6, figsize=(12, 8), subplot_kw={"xticks": [], "yticks": []}
)

for ax, city in zip(axs.flat, cities):
    cax = ax.imshow(grid, interpolation="nearest", cmap="coolwarm")
    ax.set_title(city, fontsize=10)
    
# Adjust layout and add a supertitle
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("heatmap_106.pdf", bbox_inches="tight")
