

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.colors import LogNorm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate random weather data to simulate average monthly temperatures (in degrees Celsius) over 12 months for 6 cities
np.random.seed(0)
Z = np.random.uniform(low=-5, high=30, size=(6, 12))

# Labels and parameters for titles, labels, etc.
titles = ["Average Temperature Without Edges", "Average Temperature With Edges"]
xlabel = "Month"
ylabel = "City"
city_labels = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix", "Philadelphia"]
month_labels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(2, 1, figsize=(10, 8))

# First subplot: heatmap without edges
c0 = ax0.pcolor(Z, cmap="YlOrRd")
ax0.set_title(titles[0])
ax0.set_xlabel(xlabel)
ax0.set_ylabel(ylabel)
ax0.set_xticks(np.arange(0.5, 12.5, 1))
ax0.set_xticklabels(month_labels, rotation=45, ha="right")
ax0.set_yticks(np.arange(0.5, 6.5, 1))
ax0.set_yticklabels(city_labels)

# Second subplot: heatmap with edges
c1 = ax1.pcolor(Z, edgecolors="k", linewidths=2, cmap="YlOrRd")
ax1.set_title(titles[1])
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_xticks(np.arange(0.5, 12.5, 1))
ax1.set_xticklabels(month_labels, rotation=45, ha="right")
ax1.set_yticks(np.arange(0.5, 6.5, 1))
ax1.set_yticklabels(city_labels)

# Add a color bar to show the scale
fig.colorbar(c0, ax=ax0, orientation='vertical')
fig.colorbar(c1, ax=ax1, orientation='vertical')

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_109.pdf", bbox_inches="tight")

