

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set random seed for reproducibility
np.random.seed(0)

# Cities and Years
cities = ["City A", "City B", "City C", "City D", "City E", "City F", "City G"]
years = [str(year) for year in range(2010, 2022)]

# Generate random population growth data (in thousands)
populations = np.random.uniform(low=50, high=500, size=(7, 12))

# Chart text and labels
title = "Population Growth of Cities (in thousands)"
xlabel = "Years"
ylabel = "Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))

# Use a color map that ranges from cool to warm
im = ax.imshow(populations, cmap="coolwarm")

# Show all ticks and label them with the respective list entries
ax.set_xticks(np.arange(len(years)), labels=years)
ax.set_yticks(np.arange(len(cities)), labels=cities)

# Rotate the tick labels and set their alignment.
plt.setp(ax.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(cities)):
    for j in range(len(years)):
        text = ax.text(j, i, f"{populations[i, j]:.1f}", ha="center", va="center", color="black")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_114.pdf", bbox_inches="tight")

