# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as colors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data representing patient satisfaction ratings in different health departments over four quarters
data = [[78, 85, 90, 92], [65, 70, 75, 80], [72, 78, 82, 88], [80, 83, 85, 87]]

# Axis labels
yticklabels = ["Cardiology", "Emergency", "Oncology", "Pediatrics"]
xticklabels = ["Q1", "Q2", "Q3", "Q4"]

# Chart title and other text elements
title = "Patient Satisfaction Ratings Over Four Quarters"
xlabel = "Quarters"
ylabel = "Health Departments"
cbar_yticklabels = ["Low", "Medium", "High"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a custom color scheme
colors_list = ["#FF0000", "#0000FF", "#FFA500", "#800080"]  # Red, Blue, Orange, Purple
cmap = colors.ListedColormap(colors_list)

plt.figure(figsize=(6, 5))

# Plot the heatmap with custom colors and annotations
plt.imshow(data, cmap=cmap, vmin=0, vmax=100, extent=[0, 4, 0, 4])
for i in range(4):
    for j in range(4):
        plt.annotate(
            str(data[i][j]),
            xy=(j + 0.5, i + 0.5),
            ha="center",
            va="center",
            color="white",
        )

# Add colorbar
cbar = plt.colorbar(ticks=[0, 50, 100])
cbar.ax.set_yticklabels(cbar_yticklabels)

# Set plot title and axis labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xticks([0.5, 1.5, 2.5, 3.5], xticklabels)
plt.yticks([0.5, 1.5, 2.5, 3.5], yticklabels)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot
plt.tight_layout()
plt.savefig("heatmap_116.pdf", bbox_inches="tight")
