# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for tourism-themed heatmap
data = np.random.rand(8, 12) * 0.8 + 0.1  # Scaled to avoid extreme values
title = "Tourist Visit Frequency Across Regions"
xlabel = "Months"
ylabel = "Regions"
cbar_label = "Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
cmap = "YlOrBr"  # Choose a color map that evokes the feel of old manuscripts

# Create a new figure with adjusted size
plt.figure(figsize=(10, 7))

# Set the title of the heatmap with larger font size
plt.title(title, fontsize=16, fontweight="bold")

# Set the labels for the axes with larger font size
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# Create a heatmap using pcolor function
c = plt.pcolor(data, edgecolors="w", linewidths=0.2, cmap=cmap, vmin=0.0, vmax=1.0)

# Add a colorbar to the figure with adjusted label
colorbar = plt.colorbar(c)
colorbar.set_label(cbar_label, fontsize=12)

# Improve tick parameter readability
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Display the figure with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_119.pdf", bbox_inches="tight")
