

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data in the heatmap (Visitor counts in thousands)
data = np.array(
    [
        [120.5, 150.7, 165.3, 130.2, 180.1],
        [135.2, 140.8, 170.5, 160.9, 175.4],
        [145.7, 155.3, 160.9, 175.8, 190.0],
        [125.6, 130.7, 135.4, 145.6, 155.8],
        [150.3, 160.5, 175.6, 185.4, 200.2],
        [140.2, 145.8, 150.5, 160.3, 170.6],
    ]
)

# Labels for the rows and columns
row_labels = ["January", "February", "March", "April", "May", "June"]
col_labels = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix"]

# Text labels and title
xlabel = "Cities"
ylabel = "Months"
title = "Number of Visitors to Art Exhibitions (in thousands)"
suptitle = "Monthly Visitor Data Across Cities (2023)"
annotations = "Visitor Count"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the axes
fig, ax = plt.subplots(figsize=(8, 8))

# Create the heatmap
cax = ax.matshow(data, cmap="coolwarm")  # Updated colormap

# Set the ticks
ax.set_xticks(np.arange(len(col_labels)))
ax.set_yticks(np.arange(len(row_labels)))

# Set the tick labels
ax.set_xticklabels(col_labels)
ax.set_yticklabels(row_labels)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=45, ha="left", rotation_mode="anchor")

# Move the row labels to the right side
ax.yaxis.tick_right()

# Loop over data dimensions and create text annotations
for i in range(len(row_labels)):
    for j in range(len(col_labels)):
        if not np.isnan(data[i, j]):
            text = ax.text(
                j, i, f"{data[i, j]:.1f}", ha="center", va="center", color="black"
            )

# Set the visibility of the spines
ax.spines["top"].set_visible(True)
ax.spines["right"].set_visible(True)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Set the visibility of the ticks with only the top and right axes
ax.xaxis.set_ticks_position("top")
ax.yaxis.set_ticks_position("right")

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, pad=20)
fig.suptitle(suptitle, fontsize=16)


# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("heatmap_33.pdf", bbox_inches="tight")

