
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data in the heatmap (population in millions)
data = np.array(
    [
        [320, 325, 330, 335, 340, 345],  # USA
        [80,  81,  82,  83,  84,  85],   # Germany
        [1380, 1390, 1400, 1410, 1420, 1430],  # China
        [1300, 1310, 1320, 1330, 1340, 1350],  # India
        [200, 202, 204, 206, 208, 210],  # Brazil
    ]
)

# Labels for rows and columns
row_labels = ["USA", "Germany", "China", "India", "Brazil"]
column_labels = ["2015", "2016", "2017", "2018", "2019", "2020"]

title = "Population Growth for Selected Countries (in millions)"
xlabel = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the matplotlib figure
f, ax = plt.subplots(figsize=(9, 6))

# Define the color scheme (Green to Red gradient)
color_list = ['#d73027', '#fc8d59', '#fee08b', '#d9ef8b', '#91cf60', '#1a9850']
cmap = mcolors.LinearSegmentedColormap.from_list("custom_cmap", color_list)

# Draw the heatmap
cax = ax.imshow(data, cmap=cmap)

# Set the title
ax.set_title(title, fontsize=18)

# Set labels for axes
ax.set_xlabel(xlabel, fontsize=18)
ax.set_xticks(range(len(column_labels)))
ax.set_xticklabels(column_labels)
ax.set_yticks(range(len(row_labels)))
ax.set_yticklabels(row_labels)

# Increase font size of the tick labels
ax.tick_params(axis="both", which="major", labelsize=14)

# Rotate the row labels to horizontal and set the font size
ax.set_yticklabels(ax.get_yticklabels(), rotation=0, fontsize=14)

# Add the text annotations
for i in range(len(row_labels)):
    for j in range(len(column_labels)):
        text = ax.text(
            j, i, data[i, j], ha="center", va="center", color="black", fontsize=14
        )

# Create colorbar
cbar = f.colorbar(cax, ax=ax)
cbar.ax.tick_params(labelsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to fit the figure size
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_36.pdf", bbox_inches="tight")
