
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for similarity scores among communication methods
data = np.array(
    [
        [1.00, 0.85, 0.78, 0.65, 0.80, 0.70, 0.60],
        [0.85, 1.00, 0.88, 0.75, 0.82, 0.76, 0.67],
        [0.78, 0.88, 1.00, 0.80, 0.85, 0.77, 0.70],
        [0.65, 0.75, 0.80, 1.00, 0.72, 0.68, 0.66],
        [0.80, 0.82, 0.85, 0.72, 1.00, 0.90, 0.78],
        [0.70, 0.76, 0.77, 0.68, 0.90, 1.00, 0.88],
        [0.60, 0.67, 0.70, 0.66, 0.78, 0.88, 1.00]
    ]
)

labels = ["Email", "Phone Calls", "Video Conferencing", "Instant Messaging", "Social Media", "Voice Memos", "Face-to-Face"]
title = "Communication Methods Similarity Scores"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Adjust the figure size to match the optimal dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Create the heatmap with a sophisticated colormap
cax = ax.matshow(data, cmap="viridis")

# Adjust color bar width and customize ticks
cbar = fig.colorbar(
    cax,
    fraction=0.046,
    pad=0.04,
    ticks=[0.60, 0.70, 0.80, 0.90, 1.00],
)
cbar.ax.set_yticklabels(["0.60", "0.70", "0.80", "0.90", "1.00"])

# Set axis labels
ax.set_xticks(np.arange(len(labels)))
ax.set_yticks(np.arange(len(labels)))
ax.xaxis.set_ticks_position("bottom")
ax.set_xticklabels(labels, rotation=45, ha='right')
ax.set_yticklabels(labels)

# Display the similarity scores in the cells
for i in range(len(labels)):
    for j in range(len(labels)):
        ax.text(
            j,
            i,
            f"{data[i, j]:.2f}",
            va="center",
            ha="center",
            color="black" if data[i, j] < 0.7 else "white",
            fontsize=10,
        )

# Set the title
ax.set_title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size and show the plot
fig.set_size_inches(10, 8)
fig.tight_layout()
plt.savefig("heatmap_51.pdf", bbox_inches="tight")

