

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the heatmap (Patient satisfaction scores)
data = np.array(
    [
        [0.90, 0.88, 0.84, 0.91, 0.89],
        [0.85, 0.86, 0.80, 0.87, 0.83],
        [0.78, 0.81, 0.75, 0.79, 0.77],
        [0.70, 0.73, 0.72, 0.74, 0.71],
        [0.65, 0.67, 0.68, 0.69, 0.66],
    ]
)

# Labels for the axes
hospitals = ["Hospital A", "Hospital B", "Hospital C", "Hospital D", "Hospital E"]
departments = ["Cardiology", "Neurology", "Pediatrics", "Oncology", "General Surgery"]
xlabel = "Hospitals"
ylabel = "Departments"
title = "Patient Satisfaction Scores Heatmap"
cbar_labels = ["65%", "70%", "75%", "80%", "85%", "90%"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(10, 8))  # Adjusting figure size
cax = ax.matshow(data, cmap="viridis")

# Set the ticks and labels
ax.set_xticks(np.arange(len(hospitals)))
ax.set_yticks(np.arange(len(departments)))

# Adjust the tick label alignment
ax.tick_params(
    axis="x", which="both", bottom=True, top=False, labelbottom=True, labeltop=False
)
ax.tick_params(axis="y", which="both", right=False, left=False, labelleft=True)

# Set the labels for the x-axis and rotate them for better readability
ax.set_xticklabels(hospitals, rotation=45)

# Set the labels for the y-axis
ax.set_yticklabels(departments)

# Add colorbar with the correct range
cbar = plt.colorbar(cax, ticks=[0.65, 0.7, 0.75, 0.8, 0.85, 0.9])
cbar.ax.set_yticklabels(cbar_labels)  # Set the colorbar labels

# Add labels for the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Add title to the plot
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout to add more space around the heatmap
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_62.pdf", bbox_inches="tight")

