
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the heatmap (Average scores on psychological scales for different mental health conditions)
data = np.array(
    [
        [7.5, 6.8, 5.2, 4.0],
        [6.7, 6.1, 5.5, 4.5],
        [5.9, 6.0, 5.7, 4.9],
        [5.4, 5.7, 5.8, 5.1],
    ]
)

# Mental health conditions' names for the axes
conditions = ["GAD", "MDD", "PTSD", "OCD"]
xlabel = "Mental Health Conditions"
ylabel = "Psychological Scales"
title = "Heatmap of Psychological Scale Scores"
cbar_label = "Average Score"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size
cax = ax.matshow(data, cmap="YlGnBu")

# Set the ticks and labels
ax.set_xticks(np.arange(len(conditions)))
ax.set_yticks(np.arange(len(conditions)))

# Adjust the tick label alignment to ensure the x-axis labels appear only at the bottom
ax.tick_params(
    axis="x", which="both", bottom=True, top=False, labelbottom=True, labeltop=False
)
ax.tick_params(axis="y", which="both", right=False, left=False, labelleft=True)

# Set the labels for the x-axis and rotate them for better readability
ax.set_xticklabels(conditions, rotation=45)

# Set the labels for the y-axis
ax.set_yticklabels(conditions)

# Add colorbar with the correct range
cbar = plt.colorbar(cax, ticks=[4, 5, 6, 7, 8])
cbar.ax.set_yticklabels(["4", "5", "6", "7", "8"])  # Set the colorbar labels
cbar.set_label(cbar_label)

# Add labels for the axes and the title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout to add more space around the heatmap
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_63.pdf", bbox_inches="tight")
