

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Generate new data for political predictions' confusion matrices
data_model1 = np.array(
    [
        [80, 5, 3, 2, 0],
        [10, 70, 8, 2, 0],
        [5, 10, 60, 5, 0],
        [1, 2, 3, 83, 1],
        [0, 0, 1, 5, 85],
    ]
)
data_model2 = np.array(
    [
        [75, 6, 5, 4, 0],
        [12, 65, 10, 1, 2],
        [8, 12, 55, 4, 1],
        [2, 3, 4, 80, 5],
        [1, 1, 2, 6, 90],
    ]
)

# Titles for the subplots
titles = ["Model 1 Prediction", "Model 2 Prediction"]
ylabel = "Actual Party"
xlabel = "Predicted Party"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Increase the figure height and adjust subplot layout
fig, axes = plt.subplots(nrows=1, ncols=2, figsize=(8, 6))

# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap="Blues")
    ax.set(
        title=title,
        ylabel=ylabel,
        xlabel=xlabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    ax.axhline(y=2.5, color="green", linewidth=1.5, linestyle='--')
    ax.axvline(x=2.5, color="green", linewidth=1.5, linestyle='--')
    # Unset the ticks
    ax.set_xticks([])
    ax.set_yticks([])
    # Unset the spines
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.spines["bottom"].set_visible(False)
    ax.spines["left"].set_visible(False)
    return im

# Plot each confusion matrix
im1 = plot_confusion_matrix(axes[0], data_model1, titles[0])
im2 = plot_confusion_matrix(axes[1], data_model2, titles[1])

# Adjust the position and size of the colorbars
cbar_ax1 = fig.add_axes([0.1, 0.05, 0.35, 0.02])  # Adjusted for the first subplot
cbar_ax2 = fig.add_axes([0.55, 0.05, 0.35, 0.02])  # Adjusted for the second subplot
fig.colorbar(im1, cax=cbar_ax1, orientation="horizontal")
fig.colorbar(im2, cax=cbar_ax2, orientation="horizontal")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("heatmap_66.pdf", bbox_inches="tight")

