
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data for energy consumption across sectors and years
data = np.array(
    [
        [np.nan, 130, 120, 125],
        [90, np.nan, 100, np.nan],
        [70, 85, np.nan, 95],
        [110, 105, 100, 120],
    ]
)
xticklabels = ["2018", "2019", "2020", "2021"]
yticklabels = ["Residential", "Commercial", "Industrial", "Transportation"]

# Chart title and axis labels
title = "Energy Consumption in Different Sectors Over Years"
xlabel = "Year"
ylabel = "Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a heatmap, setting NaN values' color to grey
cmap = plt.get_cmap("plasma")
cmap.set_bad("lightgrey", 1.0)

# Draw the heatmap
fig, ax = plt.subplots(figsize=(8, 6))
cax = ax.matshow(data, cmap=cmap)

# Add text
for (i, j), val in np.ndenumerate(data):
    if not np.isnan(val):  # Only add text for non-NaN values
        ax.text(j, i, f"{val}%", va="center", ha="center", color="white")

# Set title and labels
ax.set_title(title, pad=20)
ax.set_xlabel(xlabel, labelpad=15)
ax.set_ylabel(ylabel, labelpad=15)

# Set axis labels and tick labels
ax.set_xticks(np.arange(data.shape[1]))
ax.set_yticks(np.arange(data.shape[0]))
ax.set_xticklabels(xticklabels)
ax.set_yticklabels(yticklabels)

# Turn off the gridlines generated by the ticks
ax.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_67.pdf", bbox_inches="tight")
