

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Set seed for reproducibility
import numpy as np
np.random.seed(0)

# Generate a dataset for average annual precipitation (in mm) for different regions and years
data = np.array(
    [
        [np.nan, 520.5, 630.0, np.nan],
        [725.3, 580.0, np.nan, 810.1],
        [310.2, 400.0, 560.6, 780.8],
        [np.nan, 360.7, 390.9, 245.4],
    ]
)

# Define labels for the regions and years
xticklabels = ["2019", "2020", "2021", "2022"]
yticklabels = ["Region A", "Region B", "Region C", "Region D"]

# Text annotations for axis and title
xlabel = "Years"
ylabel = "Regions"
title = "Average Annual Precipitation (mm)"
suptitle = "Precipitation Data across Different Years for Various Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a custom colormap
cmap = plt.cm.get_cmap("YlGnBu")
cmap.set_bad("lightgrey", 1.0)  # Set the color for NaN values

# Draw the heatmap
fig, ax = plt.subplots(figsize=(8, 6))
cax = ax.matshow(data, cmap=cmap)

# Add text annotation for each cell
for (i, j), val in np.ndenumerate(data):
    if not np.isnan(val):  # Only add text for non-NaN values
        ax.text(j, i, f"{val:.1f} mm", va="center", ha="center", color="black", fontsize=12)

# Set axis labels and title
ax.set_xticks(np.arange(data.shape[1]))
ax.set_yticks(np.arange(data.shape[0]))
ax.set_xticklabels(xticklabels, fontsize=12)
ax.set_yticklabels(yticklabels, fontsize=12)
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, pad=20)
fig.suptitle(suptitle, fontsize=18, y=1.05)

# Remove gridlines
ax.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_68.pdf", bbox_inches="tight")

