
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Sample data to represent sales performance
data = np.array(
    [
        [5, 7, 8, 12, 15, 18],
        [np.nan, 6, 9, 11, 14, 17],
        [np.nan, np.nan, 5, 8, 11, 15],
        [np.nan, np.nan, np.nan, 7, 10, 13],
        [np.nan, np.nan, np.nan, np.nan, 8, 11],
        [np.nan, np.nan, np.nan, np.nan, np.nan, 9],
    ]
)

colorbar_label = "Sales in $K"
xlabel = "Month"
ylabel = "Region"
textstr = "Sales Performance\nTotal Sales=$105K"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Create the heatmap
cax = ax.matshow(data, cmap="viridis")

# Add colorbar
cbar = fig.colorbar(cax, label=colorbar_label, shrink=0.5)  # Add shrink parameter here

# Set axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set axis ticks
ax.set_xticks(np.arange(6))
ax.set_yticks(np.arange(6))
ax.set_xticklabels([1, 2, 3, 4, 5, 6])
ax.set_yticklabels(["Region A", "Region B", "Region C", "Region D", "Region E", ""])

# Add text box
props = dict(
    boxstyle="round",
    facecolor="white",
    alpha=0.5,
)
ax.text(
    0.05,
    0.15,
    textstr,
    transform=ax.transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("heatmap_73.pdf", bbox_inches="tight")
