# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Synthetic temperature variation data in Celsius
data = np.array(
    [
        [15, 17, 19, 21, 23, 25],
        [np.nan, 18, 20, 22, 24, 26],
        [np.nan, np.nan, 21, 23, 25, 27],
        [np.nan, np.nan, np.nan, 20, 22, 24],
        [np.nan, np.nan, np.nan, np.nan, 19, 21],
        [np.nan, np.nan, np.nan, np.nan, np.nan, 18],
    ]
)
colorbar_label = "Temperature (°C)"
xlabel = "Months"
ylabel = "Regions"
textstr = "Temperature Trend over Regions\n(Scale in Celsius)"
xticklabels = ["Jan", "Feb", "Mar", "Apr", "May", ""]
yticklabels = ["Region1", "Region2", "Region3", "Region4", "Region5", ""]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Create the heatmap with a different color map
cax = ax.matshow(data, cmap="coolwarm")

# Add colorbar with modified label and shrink parameter
cbar = fig.colorbar(cax, label=colorbar_label, shrink=0.5)

# Set axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set axis ticks
ax.set_xticks(np.arange(6))
ax.set_yticks(np.arange(6))
ax.set_xticklabels(xticklabels)
ax.set_yticklabels(yticklabels)

# Add text box with a different style
props = dict(
    boxstyle="round,pad=0.3", edgecolor="black", facecolor="#eafff5", alpha=0.8
)
ax.text(
    0.05,
    0.15,
    textstr,
    transform=ax.transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("heatmap_74.pdf", bbox_inches="tight")
