# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the heatmaps (randomly generated for demonstration purposes)
data_air_quality = (
    np.random.rand(4, 4) * 2 - 1
)  # Correlation coefficients range from -1 to 1
data_water_quality = np.random.rand(4, 4) * 2 - 1
data_soil_quality = np.random.rand(4, 4) * 2 - 1
data_biodiversity = np.random.rand(4, 4) * 2 - 1
titles = ["Air Quality", "Water Quality", "Soil Quality", "Biodiversity"]
fig_title = "Environmental Science Methods"
xticklabels = ["CO2", "NO2", "PM2.5", "O3"]
yticklabels = ["CO2", "NO2", "PM2.5", "O3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with subplots
fig, axs = plt.subplots(2, 2, figsize=(7, 6))


# Function to add text annotations
def add_annotations(ax, data):
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black")


# Air Quality heatmap
im1 = axs[0, 0].imshow(data_air_quality, cmap="Blues", vmin=-1, vmax=1)
axs[0, 0].set_title(titles[0])
add_annotations(axs[0, 0], data_air_quality)

# Water Quality heatmap
im2 = axs[0, 1].imshow(data_water_quality, cmap="Greens", vmin=-1, vmax=1)
axs[0, 1].set_title(titles[1])
add_annotations(axs[0, 1], data_water_quality)

# Soil Quality heatmap
im3 = axs[1, 0].imshow(data_soil_quality, cmap="Purples", vmin=-1, vmax=1)
axs[1, 0].set_title(titles[2])
add_annotations(axs[1, 0], data_soil_quality)

# Biodiversity heatmap
im4 = axs[1, 1].imshow(data_biodiversity, cmap="Oranges", vmin=-1, vmax=1)
axs[1, 1].set_title(titles[3])
add_annotations(axs[1, 1], data_biodiversity)

# Adjust layout and add overall title
fig.suptitle(fig_title, fontsize=16)

# Set tick labels
for ax in axs.flat:
    ax.set_xticks(np.arange(4))
    ax.set_yticks(np.arange(4))
    ax.set_xticklabels(xticklabels)
    ax.set_yticklabels(yticklabels)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to minimize white space
plt.tight_layout(rect=[0, 0, 0.9, 0.95])
# Save the figure to a file
plt.savefig("heatmap_82.pdf", bbox_inches="tight")
