

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating a dataset reflecting internet penetration rates in different regions over several years
data_2021 = pd.DataFrame(
    {
        "Region X": ["#85", "#87", "#90", "#92"],
        "Region Y": ["#75", "#77", "#80", "#82"],
        "Region Z": ["#65", "#67", "#70", "#72"],
    }
)

data_2020 = pd.DataFrame(
    {
        "Region X": ["#80", "#82", "#85", "#87"],
        "Region Y": ["#70", "#72", "#75", "#77"],
        "Region Z": ["#60", "#62", "#65", "#67"],
    }
)

# Creating a function to convert the string indices to numeric values for plotting
def convert_to_numeric(cell):
    return int(cell.replace("#", ""))

# Convert the dataframes
data_2021_numeric = data_2021.applymap(convert_to_numeric)
data_2020_numeric = data_2020.applymap(convert_to_numeric)

# Axes Limits and Labels
ax1_title = "Internet Penetration Rate 2021"
ax1_ylabel = "Penetration Rate %"
ax2_title = "Internet Penetration Rate 2020"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the heatmap using matplotlib with increased linewidths for separation
fig, (ax1, ax2) = plt.subplots(
    ncols=2, figsize=(6, 3), gridspec_kw={"width_ratios": [1, 1], "wspace": 0.1}
)

# Setting the color map to a new color scheme: Reds for 2021, Blues for 2020
cmap_2021 = plt.get_cmap("Reds")
cmap_2020 = plt.get_cmap("Blues")

# Heatmap for 2021 with increased cell borders
im1 = ax1.imshow(data_2021_numeric, cmap=cmap_2021)
ax1.set_title(ax1_title)
ax1.set_ylabel(ax1_ylabel)
ax1.set_xticks(range(len(data_2021.columns)))
ax1.set_xticklabels(data_2021.columns, rotation=45)
ax1.set_yticks(range(len(data_2021.index)))
ax1.set_yticklabels(data_2021.index, rotation=0)

# Add annotations for 2021
for i in range(len(data_2021.index)):
    for j in range(len(data_2021.columns)):
        ax1.text(j, i, data_2021.iloc[i, j], ha="center", va="center", color="black")

# Heatmap for 2020 with increased cell borders
im2 = ax2.imshow(data_2020_numeric, cmap=cmap_2020)
ax2.set_title(ax2_title)
ax2.set_xticks(range(len(data_2020.columns)))
ax2.set_xticklabels(data_2020.columns, rotation=45)
ax2.set_yticks(range(len(data_2020.index)))
ax2.set_yticklabels(data_2020.index, rotation=0)

# Add annotations for 2020
for i in range(len(data_2020.index)):
    for j in range(len(data_2020.columns)):
        ax2.text(j, i, data_2020.iloc[i, j], ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_94.pdf", bbox_inches="tight")

