
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating dummy data based on the newly chosen domain - Finance
data_Company_A = pd.DataFrame(
    {
        "Revenue Growth": ["#45", "#52", "#60", "#70"],
        "Profit Margins": ["#30", "#40", "#35", "#50"],
        "Investment": ["#80", "#75", "#70", "#85"],
    }
)

data_Company_B = pd.DataFrame(
    {
        "Revenue Growth": ["#35", "#40", "#45", "#50"],
        "Profit Margins": ["#55", "#60", "#50", "#45"],
        "Investment": ["#65", "#70", "#75", "#80"],
    }
)

# Creating a function to convert the string indices to numeric values for plotting
def convert_to_numeric(cell):
    return int(cell.replace("#", ""))

# Convert the dataframes to numeric values
data_Company_A_numeric = data_Company_A.applymap(convert_to_numeric)
data_Company_B_numeric = data_Company_B.applymap(convert_to_numeric)

# Axes Limits and Labels
ax1_title = "Company A Performance"
ax1_ylabel = "Quarter"
ax2_title = "Company B Performance"

# Label settings
xlabels = ["Revenue Growth", "Profit Margins", "Investment"]
ylabels = ["Quarter 1", "Quarter 2", "Quarter 3", "Quarter 4"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the heatmap using matplotlib with increased linewidths for separation
fig, (ax1, ax2) = plt.subplots(
    ncols=2, figsize=(10, 5), gridspec_kw={"width_ratios": [1, 1], "wspace": 0.3}
)

# Setting the color map to match the political theme: Reds for Company A, Blues for Company B
cmap_Company_A = plt.get_cmap("Reds")
cmap_Company_B = plt.get_cmap("Blues")

# Heatmap for Company A with increased cell borders
im1 = ax1.imshow(data_Company_A_numeric, cmap=cmap_Company_A)
ax1.set_title(ax1_title)
ax1.set_ylabel(ax1_ylabel)
ax1.set_xticks(range(len(data_Company_A.columns)))
ax1.set_xticklabels(xlabels, rotation=45, ha="right")
ax1.set_yticks(range(len(data_Company_A.index)))
ax1.set_yticklabels(ylabels, rotation=0)

# Add annotations for Company A
for i in range(len(data_Company_A.index)):
    for j in range(len(data_Company_A.columns)):
        ax1.text(j, i, data_Company_A.iloc[i, j], ha="center", va="center", color="black")

# Heatmap for Company B with increased cell borders
im2 = ax2.imshow(data_Company_B_numeric, cmap=cmap_Company_B)
ax2.set_title(ax2_title)
ax2.set_xticks(range(len(data_Company_B.columns)))
ax2.set_xticklabels(xlabels, rotation=45, ha="right")
ax2.set_yticks(range(len(data_Company_B.index)))
ax2.set_yticklabels(ylabels, rotation=0)

# Add annotations for Company B
for i in range(len(data_Company_B.index)):
    for j in range(len(data_Company_B.columns)):
        ax2.text(j, i, data_Company_B.iloc[i, j], ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_95.pdf", bbox_inches="tight")
