

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Define the data for the original and adjusted values (annual significant historical events)
original_values = [5, 7, 6, 3, 8, 9, 4, 2]
adjusted_values = [6, 8, 7, 4, 9, 10, 5, 3]  # After adjustment

# Labels and text content
regions = ['Region A', 'Region B', 'Region C', 'Region D', 'Region E', 'Region F', 'Region G', 'Region H']
xlabel = 'Regions'
ylabel = 'Significant Historical Events (count)'
title1 = 'Original Annual Significant Historical Events'
title2 = 'Adjusted Annual Significant Historical Events'
suptitle = 'Annual Significant Historical Events Comparison (Original vs Adjusted)'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for original and one for adjusted values)
fig, axs = plt.subplots(2, 1, figsize=(12, 5), sharex=True)

# Define the color palette for historical events
cmap = plt.get_cmap("Blues")

# Plot heatmap for original values
im1 = axs[0].imshow(pd.DataFrame([original_values], index=[""]), cmap=cmap)
axs[0].set_xticks(np.arange(len(regions)))
axs[0].set_xticklabels(regions, rotation=45, ha="right")
axs[0].set_yticks([])
axs[0].set_title(title1)

# Add annotations for original values
for j in range(len(original_values)):
    color = "white" if original_values[j] > np.mean(original_values) else "black"
    axs[0].text(j, 0, f"{original_values[j]:.1f}", ha="center", va="center", color=color)

# Plot heatmap for adjusted values
im2 = axs[1].imshow(pd.DataFrame([adjusted_values], index=[""]), cmap=cmap)
axs[1].set_xticks(np.arange(len(regions)))
axs[1].set_xticklabels(regions, rotation=45, ha="right")
axs[1].set_yticks([])
axs[1].set_title(title2)

# Add annotations for adjusted values
for j in range(len(adjusted_values)):
    color = "white" if adjusted_values[j] > np.mean(adjusted_values) else "black"
    axs[1].text(j, 0, f"{adjusted_values[j]:.1f}", ha="center", va="center", color=color)

# ===================
# Part 4: Saving Output
# ===================
# Add a super title for the figure
fig.suptitle(suptitle, fontsize=16)

# Display the figure with tight layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("heatmap_97.pdf", bbox_inches="tight")

