
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Define the data for the original and adjusted values
brands = ["Apple", "Samsung", "Huawei", "Xiaomi", "Oppo"]
region_x_values = [0.30, 0.25, 0.20, 0.15, 0.10]  # Region X
region_y_values = [0.25, 0.30, 0.15, 0.20, 0.10]  # Region Y

# Text labels
xlabel = "Smartphone Brands"
ylabel = "Market Share"
title_region_x = "Region X: Smartphone Market Share"
title_region_y = "Region Y: Smartphone Market Share"
supertitle = "Comparison of Smartphone Market Shares in Two Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for original and one for adjusted values)
fig, axs = plt.subplots(2, 1, figsize=(10, 6), sharex=True, sharey=True)

# Define the color palette
cmap_region_x = plt.get_cmap("Blues")
cmap_region_y = plt.get_cmap("Greens")

# Plot heatmap for region_x_values
im1 = axs[0].imshow(pd.DataFrame([region_x_values], index=[""], columns=brands), cmap=cmap_region_x)
axs[0].set_xticks(range(len(brands)))
axs[0].set_xticklabels(brands)
axs[0].set_yticks([])
axs[0].set_title(title_region_x)

# Add annotations for region_x_values
for j in range(len(region_x_values)):
    color = "white" if region_x_values[j] > 0.25 else "black"
    axs[0].text(j, 0, f"{region_x_values[j]:.2f}", ha="center", va="center", color=color)

# Plot heatmap for region_y_values
im2 = axs[1].imshow(pd.DataFrame([region_y_values], index=[""], columns=brands), cmap=cmap_region_y)
axs[1].set_xticks(range(len(brands)))
axs[1].set_xticklabels(brands)
axs[1].set_yticks([])
axs[1].set_title(title_region_y)

# Add annotations for region_y_values
for j in range(len(region_y_values)):
    color = "white" if region_y_values[j] > 0.25 else "black"
    axs[1].text(j, 0, f"{region_y_values[j]:.2f}", ha="center", va="center", color=color)

# Overall figure adjustments
plt.suptitle(supertitle)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Display the figure with tight layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust for super title
plt.savefig("heatmap_98.pdf", bbox_inches="tight")
