# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating data for Daily Exercise Hours
sizes = np.linspace(300, 100, 6, dtype=int)  # Generate sizes from 300 to 100
data = [
    np.abs(np.random.normal(loc, scale, size))
    for loc, scale, size in zip(
        [1.5, 2.0, 0.5, 1.0, 1.8, 2.5],  # Different means for each group
        [0.4, 0.3, 0.2, 0.25, 0.35, 0.5],  # Different scales for each group
        sizes,
    )
]

labels = ["Teenagers", "Adults", "Seniors", "Children", "Athletes", "Professionals"]
xlabel = "Daily Exercise Hours"
ylabel = "Frequency"
xlim = [0, 4]
xticks = [0.0, 1.0, 2.0, 3.0, 4.0]
bins = 30

title = "Daily Exercise Hours by Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

plt.figure(figsize=(10, 8))
plt.hist(
    data,
    bins=bins,
    stacked=True,
    edgecolor="black",
    linewidth=1.2,
    color=colors,
    label=labels,
)

# Set background color to white
ax = plt.gca()
ax.set_facecolor("white")

# Labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(xlim)
plt.xticks(xticks)
plt.title(title)

handles, labels = plt.gca().get_legend_handles_labels()

# Reverse handles and labels
handles = handles[::-1]
labels = labels[::-1]

plt.legend(handles, labels)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the plot to match the original image's dimensions
plt.tight_layout()
plt.savefig("hist_21.pdf", bbox_inches="tight")
