
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating crop yields data
sizes = np.linspace(300, 100, 6, dtype=int)  # Generate sizes from 300 to 100
data = [
    np.random.normal(50, 15, size) for size in sizes
]  # Generate data with mean 50 and standard deviation 15

# Labels and settings
labels = [
    "Region 1",
    "Region 2",
    "Region 3",
    "Region 4",
    "Region 5",
    "Region 6",
]
xlabel = "Crop Yield (kg/acre)"
ylabel = "Frequency"
title = "Distribution of Crop Yields for Various Regions"
xlim = [0, 100]
xticks = [0, 20, 40, 60, 80, 100]
bins = 30

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot
colors = ["#73d216", "#4e9a06", "#c4a000", "#ef2929", "#cc0000", "#a40000"]

plt.figure(figsize=(10, 8))
plt.hist(
    data,
    bins=bins,
    stacked=True,
    edgecolor="black",
    linewidth=1.2,
    color=colors,
    label=labels,
)

# Set background color to white
ax = plt.gca()
ax.set_facecolor("white")

# Labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.xlim(xlim)
plt.xticks(xticks)
handles, labels = plt.gca().get_legend_handles_labels()

# Reverse handles and labels
handles = handles[::-1]
labels = labels[::-1]

plt.legend(handles, labels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("hist_22.pdf", bbox_inches="tight")
