# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating sports score data
sizes = np.linspace(250, 100, 4, dtype=int)  # Generate sizes for data arrays

data_team1 = np.abs(
    np.random.normal(70, 15, sizes[0])
)  # Team 1: Consistent Performance
data_team2 = np.abs(np.random.normal(80, 20, sizes[1]))  # Team 2: High Variability
data_team3 = np.abs(
    np.random.normal(60, 10, sizes[2])
)  # Team 3: Stable Low Performance
data_team4 = np.abs(
    np.random.normal(90, 25, sizes[3])
)  # Team 4: Highly Variable High Scores

labels = [
    "Team 1: Consistent",
    "Team 2: Variable",
    "Team 3: Stable Low",
    "Team 4: High Variability",
]
xlabel = "Scores"
ylabel = "Frequency"
bins = np.linspace(0, 150, 20)
title = "Score Distribution Across Different Teams"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

plt.figure(figsize=(10, 7))  # Adjusted for better readability

plt.hist(
    [data_team1, data_team2, data_team3, data_team4],
    bins=bins,
    stacked=True,
    label=labels,
    color=colors,
    edgecolor="black",
)

# Labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)
plt.legend(loc="upper right")

# Adding grid for better readability
plt.grid(True, linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_25.pdf", bbox_inches="tight")
