# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Simulating energy consumption data (in MWh)
sizes = np.linspace(
    500, 200, 4, dtype=int
)  # Generate sizes for different dataset sizes

data_solar = np.abs(np.random.normal(50, 10, sizes[0]))  # Solar energy consumption
data_wind = np.abs(np.random.normal(60, 15, sizes[1]))  # Wind energy consumption
data_hydro = np.abs(np.random.normal(70, 12, sizes[2]))  # Hydro energy consumption
data_fossil = np.abs(
    np.random.normal(80, 20, sizes[3])
)  # Fossil fuel energy consumption

labels = ["Solar", "Wind", "Hydro", "Fossil Fuels"]
xlabel = "Energy Consumption (MWh)"
ylabel = "Frequency"
bins = np.linspace(0, 150, 20)  # Adjusted for plausible range of energy data
title = "Daily Energy Consumption Statistics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot

colors = ["#f08080", "#87cefa", "#98fb98", "#dda0dd"]

plt.figure(figsize=(10, 6))  # Adjusted the size for better visibility and aesthetics

plt.hist(
    [data_solar, data_wind, data_hydro, data_fossil],
    bins=bins,
    stacked=True,
    label=labels,
    color=colors,
    edgecolor="black",
    alpha=0.75,  # Adding some transparency for better visibility
)

# Labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)
plt.legend()

# Adding grid lines for better readability
plt.grid(axis="y", linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_26.pdf", bbox_inches="tight")
